/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.connected;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import slimeknights.mantle.block.IMultipartConnectedBlock;
import slimeknights.mantle.client.model.connected.ConnectedModelRegistry;
import slimeknights.mantle.client.model.data.SinglePropertyData;
import slimeknights.mantle.client.model.util.DynamicBakedWrapper;
import slimeknights.mantle.client.model.util.ExtraTextureConfiguration;
import slimeknights.mantle.client.model.util.ModelTextureIteratable;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class ConnectedModel
implements IModelGeometry<ConnectedModel> {
    private static final ModelProperty<Byte> CONNECTIONS = new ModelProperty();
    private final SimpleBlockModel model;
    private final Map<String, String[]> connectedTextures;
    private final BiPredicate<BlockState, BlockState> connectionPredicate;
    private final Set<Direction> sides;
    private Map<String, Material> extraTextures;

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        Collection<Material> textures = this.model.getTextures(owner, modelGetter, missingTextureErrors);
        HashMap<CallSite, Material> extraTextures = new HashMap<CallSite, Material>();
        for (Map.Entry<String, String[]> entry : this.connectedTextures.entrySet()) {
            String[] suffixes;
            String name = entry.getKey();
            if (!owner.isTexturePresent(name)) continue;
            Material base = owner.resolveTexture(name);
            ResourceLocation atlas = base.m_119193_();
            ResourceLocation texture = base.m_119203_();
            String namespace = texture.m_135827_();
            String path = texture.m_135815_();
            for (String suffix : suffixes = entry.getValue()) {
                String suffixedName;
                if (suffix.isEmpty() || extraTextures.containsKey(suffixedName = name + "_" + suffix)) continue;
                Material mat = owner.isTexturePresent(suffixedName) ? owner.resolveTexture(suffixedName) : new Material(atlas, new ResourceLocation(namespace, path + "/" + suffix));
                textures.add(mat);
                extraTextures.put((CallSite)((Object)suffixedName), mat);
            }
        }
        this.extraTextures = ImmutableMap.copyOf(extraTextures);
        return textures;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked = this.model.bakeModel(owner, transform, overrides, spriteGetter, location);
        return new Baked(this, new ExtraTextureConfiguration(owner, this.extraTextures), transform, baked);
    }

    protected ConnectedModel(SimpleBlockModel model, Map<String, String[]> connectedTextures, BiPredicate<BlockState, BlockState> connectionPredicate, Set<Direction> sides) {
        this.model = model;
        this.connectedTextures = connectedTextures;
        this.connectionPredicate = connectionPredicate;
        this.sides = sides;
    }

    protected static class Baked
    extends DynamicBakedWrapper<BakedModel> {
        private final ConnectedModel parent;
        private final IModelConfiguration owner;
        private final ModelState transforms;
        private final BakedModel[] cache = new BakedModel[64];
        private final Map<String, String> nameMappingCache = new ConcurrentHashMap<String, String>();
        private final ModelTextureIteratable modelTextures;

        public Baked(ConnectedModel parent, IModelConfiguration owner, ModelState transforms, BakedModel baked) {
            super(baked);
            this.parent = parent;
            this.owner = owner;
            this.transforms = transforms;
            this.modelTextures = ModelTextureIteratable.of(owner, parent.model);
            this.cache[0] = baked;
        }

        private static Direction rotateDirection(Direction direction, Direction rotation) {
            if (rotation == Direction.UP) {
                return direction;
            }
            if (rotation == Direction.DOWN) {
                if (direction.m_122434_() == Direction.Axis.Z) {
                    return direction.m_122424_();
                }
                return direction;
            }
            switch (direction) {
                case NORTH: {
                    return Direction.UP;
                }
                case SOUTH: {
                    return Direction.DOWN;
                }
                case EAST: {
                    return rotation.m_122428_();
                }
                case WEST: {
                    return rotation.m_122427_();
                }
            }
            throw new IllegalArgumentException("Direction must be horizontal axis");
        }

        private static Function<Direction, Direction> getTransform(Direction face, BlockFaceUV uv) {
            boolean flipV;
            Function<Direction, Direction> transform = d -> Baked.rotateDirection(d, face);
            boolean bl = flipV = uv.f_111387_[1] > uv.f_111387_[3];
            if (uv.f_111387_[0] > uv.f_111387_[2]) {
                transform = flipV ? transform.compose(Direction::m_122424_) : transform.compose(d -> {
                    if (d.m_122434_() == Direction.Axis.X) {
                        return d.m_122424_();
                    }
                    return d;
                });
            } else if (flipV) {
                transform = transform.compose(d -> {
                    if (d.m_122434_() == Direction.Axis.Z) {
                        return d.m_122424_();
                    }
                    return d;
                });
            }
            return switch (uv.f_111388_) {
                case 90 -> transform.compose(Direction::m_122427_);
                case 180 -> transform.compose(Direction::m_122424_);
                case 270 -> transform.compose(Direction::m_122428_);
                default -> transform;
            };
        }

        private String getConnectedNameUncached(String key) {
            String check = key;
            String found = "";
            for (Map textures : this.modelTextures) {
                Either either = (Either)textures.get(check);
                if (either == null) continue;
                Optional newName = either.right();
                if (newName.isEmpty()) break;
                check = (String)newName.get();
                if (!this.parent.connectedTextures.containsKey(check)) continue;
                found = check;
                break;
            }
            return found;
        }

        private String getConnectedName(String key) {
            if (key.charAt(0) == '#') {
                key = key.substring(1);
            }
            if (this.parent.connectedTextures.containsKey(key)) {
                return key;
            }
            return this.nameMappingCache.computeIfAbsent(key, this::getConnectedNameUncached);
        }

        private String getTextureSuffix(String texture, byte connections, Function<Direction, Direction> transform) {
            int key = 0;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                int flag = 1 << transform.apply(dir).m_122411_();
                if ((connections & flag) != flag) continue;
                key |= 1 << dir.m_122416_();
            }
            String[] suffixes = this.parent.connectedTextures.get(texture);
            assert (suffixes != null);
            String suffix = suffixes[key];
            if (suffix.isEmpty()) {
                return suffix;
            }
            return "_" + suffix;
        }

        private BakedModel applyConnections(byte connections) {
            ArrayList elements = Lists.newArrayList();
            for (BlockElement part : this.parent.model.getElements()) {
                EnumMap<Direction, BlockElementFace> partFaces = new EnumMap<Direction, BlockElementFace>(Direction.class);
                for (Map.Entry entry : part.f_111310_.entrySet()) {
                    String suffix;
                    BlockElementFace original;
                    Direction dir = (Direction)entry.getKey();
                    BlockElementFace face = original = (BlockElementFace)entry.getValue();
                    String connectedTexture = this.getConnectedName(original.f_111356_);
                    if (!connectedTexture.isEmpty() && !(suffix = this.getTextureSuffix(connectedTexture, connections, Baked.getTransform(dir, original.f_111357_))).isEmpty()) {
                        String fullTexture = connectedTexture + suffix;
                        face = new BlockElementFace(original.f_111354_, original.f_111355_, "#" + fullTexture, original.f_111357_);
                    }
                    partFaces.put(dir, face);
                }
                elements.add(new BlockElement(part.f_111308_, part.f_111309_, partFaces, part.f_111311_, part.f_111312_));
            }
            return SimpleBlockModel.bakeDynamic(this.owner, elements, this.transforms);
        }

        private static byte getConnections(Predicate<Direction> predicate) {
            byte connections = 0;
            for (Direction dir : Direction.values()) {
                if (!predicate.test(dir)) continue;
                connections = (byte)(connections | 1 << dir.m_122411_());
            }
            return connections;
        }

        @Nonnull
        public IModelData getModelData(BlockAndTintGetter world, BlockPos pos, BlockState state, IModelData tileData) {
            if (tileData.getData(CONNECTIONS) != null) {
                return tileData;
            }
            SinglePropertyData<Byte> data = tileData;
            if (!data.hasProperty(CONNECTIONS)) {
                data = new SinglePropertyData<Byte>(CONNECTIONS);
            }
            Transformation rotation = this.transforms.m_6189_();
            data.setData(CONNECTIONS, Baked.getConnections(dir -> this.parent.sides.contains(dir) && this.parent.connectionPredicate.test(state, world.m_8055_(pos.m_142300_(rotation.rotateTransform(dir))))));
            return data;
        }

        protected synchronized List<BakedQuad> getCachedQuads(byte connections, @Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
            if (this.cache[connections] == null) {
                this.cache[connections] = this.applyConnections(connections);
            }
            return this.cache[connections].getQuads(state, side, rand, data);
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData data) {
            Byte connections = (Byte)data.getData(CONNECTIONS);
            if (connections == null) {
                if (state == null) {
                    return this.originalModel.getQuads(null, side, rand, data);
                }
                Transformation rotation = this.transforms.m_6189_();
                connections = Baked.getConnections(dir -> {
                    if (!this.parent.sides.contains(dir)) {
                        return false;
                    }
                    BooleanProperty prop = IMultipartConnectedBlock.CONNECTED_DIRECTIONS.get(rotation.rotateTransform(dir));
                    return state.m_61138_((Property)prop) && (Boolean)state.m_61143_((Property)prop) != false;
                });
            }
            return this.getCachedQuads(connections, state, side, rand, data);
        }
    }

    public static class Loader
    implements IModelLoader<ConnectedModel> {
        public static final Loader INSTANCE = new Loader();

        public void m_6213_(ResourceManager resourceManager) {
        }

        public ConnectedModel read(JsonDeserializationContext context, JsonObject json) {
            EnumSet<Direction> sides;
            SimpleBlockModel model = SimpleBlockModel.deserialize(context, json);
            JsonObject data = GsonHelper.m_13930_((JsonObject)json, (String)"connection");
            JsonObject connected = GsonHelper.m_13930_((JsonObject)data, (String)"textures");
            if (connected.size() == 0) {
                throw new JsonSyntaxException("Must have at least one texture in connected");
            }
            ImmutableMap.Builder connectedTextures = new ImmutableMap.Builder();
            for (Map.Entry entry : connected.entrySet()) {
                String name = (String)entry.getKey();
                connectedTextures.put((Object)name, (Object)ConnectedModelRegistry.deserializeType((JsonElement)entry.getValue(), "textures[" + name + "]"));
            }
            if (data.has("sides")) {
                JsonArray array = GsonHelper.m_13933_((JsonObject)data, (String)"sides");
                sides = EnumSet.noneOf(Direction.class);
                for (int i = 0; i < array.size(); ++i) {
                    String side = GsonHelper.m_13805_((JsonElement)array.get(i), (String)("sides[" + i + "]"));
                    Direction dir = Direction.m_122402_((String)side);
                    if (dir == null) {
                        throw new JsonParseException("Invalid side " + side);
                    }
                    sides.add(dir);
                }
            } else {
                sides = EnumSet.allOf(Direction.class);
            }
            BiPredicate<BlockState, BlockState> predicate = ConnectedModelRegistry.deserializePredicate(data, "predicate");
            return new ConnectedModel(model, (Map<String, String[]>)connectedTextures.build(), predicate, sides);
        }
    }
}

